% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_plots.R
\name{results_pivot_longer}
\alias{results_pivot_longer}
\alias{combined_plot}
\title{Functions for Plotting and Reporting Results}
\usage{
results_pivot_longer(data, exclude_from_methods = c("descriptive"))

combined_plot(
  data,
  methods,
  xvars,
  yvar,
  facet_x_vars = c(),
  facet_y_vars = c(),
  split_var = 1,
  heights_plots = c(3, 1),
  scale_stairs = NULL,
  grid_level = 2,
  scales = "fixed",
  hlines = numeric(0),
  use_colours = NULL,
  use_shapes = NULL,
  expand_x_axis = c(0.05, 0, 0.05, 0)
)
}
\arguments{
\item{data}{for results_pivot_longer: simulation result as retured by SimDesign, for combined_plot: simulation results in long format, as returned by \code{results_pivot_longer}.}

\item{exclude_from_methods}{"methods" that should not be pivoted into long format}

\item{methods}{methods to include in the plot}

\item{xvars}{orderd vector of variable names to display on the x axis}

\item{yvar}{variable name of the variable to be displayed on the y axis (metric)}

\item{facet_x_vars}{vector of variable names to create columns of facets}

\item{facet_y_vars}{vector of variable names to create rows of facets}

\item{split_var}{where should the lines be split, see details}

\item{heights_plots}{relative heights of the main plot and the stairs on the bottom}

\item{scale_stairs}{this argument is deprecated and will be ignored}

\item{grid_level}{depth of loops for which the grid-lines are drawn}

\item{scales}{passed on to facet_grid}

\item{hlines}{position of horizontal lines, passed as \code{yintercept} to
\code{geom_hline}}

\item{use_colours}{optional named vector of colours used in \code{scale_colour_manual}}

\item{use_shapes}{optional named vector of shapes used in \code{scale_shape_manual}}

\item{expand_x_axis}{axis expansion factor, passed to \code{scale_x_continuous}}
}
\value{
dataset in long format with one row per method and scenario and one
column per metric

a ggplot/patchwork object containing the plots
}
\description{
Functions for Plotting and Reporting Results
}
\details{
With \code{exclude_from_methods} descriptive statistics or results of
reference methods can be kept as own columns and used like the columns of
the simulation parameters.

\code{use_colours} and \code{use_shapes} both use the \code{method} variable in their respective aesthetics.

\code{split_var} break the lines after the 1st, 2nd, ... variable in \code{xvars}. Use 0 for one continuous line per method.
}
\section{Functions}{
\itemize{
\item \code{results_pivot_longer()}: pivot simulation results into long format

\item \code{combined_plot()}: Nested Loop Plot with optional Facets

}}
\examples{
\donttest{
data("combination_tests_delayed")

combination_tests_delayed |>
  results_pivot_longer() |>
  head()
}
\donttest{
library("ggplot2")
library("patchwork")
data("combination_tests_delayed")

results_long <- results_pivot_longer(combination_tests_delayed)

# plot the rejection rate of two methods
combined_plot(
  results_long,
  c("logrank", "mwlrt", "maxcombo"),
  c("hr", "n_pat_design", "delay", "hazard_ctrl", "recruitment"),
  "rejection_0.025",
  grid_level=2
)

# use custom colour and shape scales
# this can be used to group methods by shape or colour
# this is also helpful if methods should have the same aesthetics across plots
my_colours <- c(
  logrank="black",
  mwlrt="blue",
  maxcombo="green"
)

my_shapes <- c(
  logrank=1,
  mwlrt=2,
  maxcombo=2
)

combined_plot(
  results_long,
  c("logrank", "mwlrt", "maxcombo"),
  c("hr", "n_pat_design", "delay", "hazard_ctrl", "recruitment"),
  "rejection_0.025",
  grid_level=2,
  use_colours = my_colours,
  use_shapes = my_shapes
)

# if one has a dataset of metadata with categories of methods
# one could uses those two definitions
# colours for methods, same shapes for methods of same category
metadata <- data.frame(
  method = c("logrank", "mwlrt", "maxcombo"),
  method_name = c("logrank test", "modestly weighed logrank test", "maxcombo test"),
  category = c("logrank test", "combination test", "combination test")
)

my_colours <- rainbow(n=nrow(metadata)) |>
  sample() |>
  setNames(metadata$method)

my_shapes <- metadata$category |>
  as.factor() |>
  as.integer() |>
  setNames(metadata$method)

combined_plot(
  results_long,
  c("logrank", "mwlrt", "maxcombo"),
  c("hr", "n_pat_design", "delay", "hazard_ctrl", "recruitment"),
  "rejection_0.025",
  grid_level=2,
  use_colours = my_colours,
  use_shapes = my_shapes
)
}
}
