% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blis.R
\name{get_orig_levels}
\alias{get_orig_levels}
\title{Get Original Levels from a Fitted BLIS model}
\usage{
get_orig_levels(object)
}
\arguments{
\item{object}{\emph{object of class \linkS4class{BlisClass}}, model fitted via \code{fit_blis()} or
\code{blis()}.}
}
\value{
\emph{list} of the original levels and correct key. Key is stored as an
attribute \code{key} for every individual item.
}
\description{
Just a simple accessor to original levels and correct key stored in fitted
BLIS model.
}
\examples{
fit <- fit_blis(HCItest[, 1:20], HCIkey)
get_orig_levels(fit)
}
\seealso{
Other BLIS/BLIRT related: 
\code{\link{BlisClass-class}},
\code{\link{coef,BlisClass-method}},
\code{\link{fit_blis}()},
\code{\link{nominal_to_int}()},
\code{\link{obtain_nrm_def}()},
\code{\link{print.blis_coefs}()}
}
\concept{BLIS/BLIRT related}
