% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\name{[[.Assay}
\alias{[[.Assay}
\alias{[[<-,Assay,ANY,ANY,ANY-method}
\alias{head.Assay}
\alias{tail.Assay}
\alias{[[<-,Assay,missing,missing,data.frame-method}
\title{Feature-Level Meta Data}
\usage{
\method{[[}{Assay}(x, i, ..., drop = FALSE)

\S4method{[[}{Assay,ANY,ANY,ANY}(x, i, j, ...) <- value

\method{head}{Assay}(x, n = 10L, ...)

\method{tail}{Assay}(x, n = 10L, ...)

\S4method{[[}{Assay,missing,missing,data.frame}(x, i, j, ...) <- value
}
\arguments{
\item{x}{An \code{\link{Assay}} object}

\item{i}{Name of feature-level meta data to fetch or add}

\item{...}{Ignored}

\item{drop}{See \code{\link{drop}}}

\item{j}{Ignored}

\item{value}{Feature-level meta data to add}

\item{n}{Number of meta data rows to show}
}
\value{
\code{[[}: The feature-level meta data for \code{i}

\code{[[<-}: \code{x} with \code{value} added as \code{i}
in feature-level meta data

\code{head}: The first \code{n} rows of feature-level meta data

\code{tail}: the last \code{n} rows of feature-level meta data
}
\description{
Get and set feature-level meta data
}
\examples{
rna <- pbmc_small[["RNA"]]

# Pull the entire feature-level meta data data frame
head(rna[[]])

# Pull a specific column of feature-level meta data
head(rna[["vst.mean"]])
head(rna[["vst.mean", drop = TRUE]])

# `head` and `tail` can be used to quickly view feature-level meta data
head(rna)

tail(rna)

}
\seealso{
v3 Assay object, validity, and interaction methods:
\code{\link{$.Assay}()},
\code{\link{Assay-class}},
\code{\link{Assay-validity}},
\code{\link{CreateAssayObject}()},
\code{\link{[.Assay}()},
\code{\link{dim.Assay}()},
\code{\link{dimnames.Assay}()},
\code{\link{merge.Assay}()},
\code{\link{split.Assay}()},
\code{\link{subset.Assay}()}
}
\concept{assay}
