% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\name{[.Assay}
\alias{[.Assay}
\alias{[<-,Assay,character,ANY,ANY-method}
\title{Layer Data}
\usage{
\method{[}{Assay}(x, i = missing_arg(), j = missing_arg(), ...)

\S4method{[}{Assay,character,ANY,ANY}(x, i, j, ...) <- value
}
\arguments{
\item{x}{An \code{\link{Assay}} object}

\item{i}{Name of layer data to get or set}

\item{j}{Ignored}

\item{...}{Arguments passed to \code{\link{LayerData}}}

\item{value}{A matrix-like object to add as a new layer}
}
\value{
\code{[}: The layer data for layer \code{i}

\code{[<-}: \code{x} with layer data \code{value} saved as \code{i}
}
\description{
Get and set layer data
}
\examples{
rna <- pbmc_small[["RNA"]]

# Get a vector of layer names in this assay
rna[]

# Fetch layer data
rna["data"][1:10, 1:4]

# Set layer data
rna["data"] <- rna["counts"]
rna["data"][1:10, 1:4]

}
\seealso{
\code{\link{LayerData}}

v3 Assay object, validity, and interaction methods:
\code{\link{$.Assay}()},
\code{\link{Assay-class}},
\code{\link{Assay-validity}},
\code{\link{CreateAssayObject}()},
\code{\link{[[.Assay}()},
\code{\link{dim.Assay}()},
\code{\link{dimnames.Assay}()},
\code{\link{merge.Assay}()},
\code{\link{split.Assay}()},
\code{\link{subset.Assay}()}
}
\concept{assay}
