% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/seurat.R
\name{Tool}
\alias{Tool}
\alias{Tools}
\alias{Tool<-}
\alias{Tool.Seurat}
\alias{Tool<-.Seurat}
\title{Get and Set Additional Tool Data}
\usage{
Tool(object, ...)

Tool(object, ...) <- value

\method{Tool}{Seurat}(object, slot = NULL, ...)

\method{Tool}{Seurat}(object, ...) <- value
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{value}{Information to be added to tool list}

\item{slot}{Name of tool to pull}
}
\value{
If no additional arguments, returns the names of the tools in the
object; otherwise returns the data placed by the tool requested
}
\description{
Use \code{Tool} to get tool data. If no additional arguments are provided,
will return a vector with the names of tools in the object.
}
\note{
For developers: set tool data using \code{Tool<-}. \code{Tool<-} will
automatically set the name of the tool to the function that called
\code{Tool<-}, so each function gets one entry in the tools list and cannot
overwrite another function's entry. The automatic naming will also remove any
method identifiers (eg. \code{RunPCA.Seurat} will become \code{RunPCA});
please plan accordingly
}
\examples{
# Example function that adds unstructured data to tools
MyTool <- function(object) {
  sample.tool.output <- matrix(rnorm(n = 16), nrow = 4)
  # Note: `Tool<-` must be called from within a function
  # and the name of the tool will be generated from the function name
  Tool(object) <- sample.tool.output
  return(object)
}

# Run our tool
set.seed(42L)
pbmc_small <- MyTool(pbmc_small)

# Get a list of tools run
Tool(pbmc_small)

# Access specific tool data
Tool(pbmc_small, slot = "MyTool")

}
\concept{data-access}
