% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SettingsObjects.R
\name{createGetDbSccsDataArgs}
\alias{createGetDbSccsDataArgs}
\title{Create a parameter object for the function getDbSccsData}
\usage{
createGetDbSccsDataArgs(
  nestingCohortId = NULL,
  deleteCovariatesSmallCount = 0,
  studyStartDates = c(),
  studyEndDates = c(),
  maxCasesPerOutcome = 0,
  exposureIds = "exposureId",
  customCovariateIds = NULL
)
}
\arguments{
\item{nestingCohortId}{A cohort definition ID identifying the records in the nestingCohortTable to use as nesting cohort.}

\item{deleteCovariatesSmallCount}{The minimum count for a covariate to appear in the data to be kept.}

\item{studyStartDates}{A character object specifying the minimum dates where data is used. Date format is 'yyyymmdd'. Use "" to indicate all time prior. See section for more information.}

\item{studyEndDates}{A character object specifying the maximum dates where data is used. Date format is 'yyyymmdd'. Use "" to indicate to the end of observation. See section for more information.}

\item{maxCasesPerOutcome}{If there are more than this number of cases for a single outcome cases will be sampled to this size. maxCasesPerOutcome = 0 indicates no maximum size.}

\item{exposureIds}{A list of identifiers to extract from the exposure table. If exposureTable = DRUG_ERA, exposureIds should be CONCEPT_ID. If exposureTable = "drug_era", exposureIds is used to select the drug_concept_id. If no exposure IDs are provided, all drugs or cohorts in the exposureTable are included as exposures.}

\item{customCovariateIds}{A list of cohort definition IDs identifying the records in the customCovariateTable to use for building custom covariates.}
}
\value{
An object of type \code{GetDbSccsDataArgs}.
}
\description{
Create a parameter object for the function getDbSccsData
}
\details{
Create an object defining the parameter values.
}
