% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigexp.R
\name{bigexp_prepare}
\alias{bigexp_prepare}
\title{Prepare data to match a bigexp_spec (stable expansion across datasets)}
\usage{
bigexp_prepare(spec, data, unseen = c("warn_na", "error"))
}
\arguments{
\item{spec}{Object returned by \code{\link[=bigexp_terms]{bigexp_terms()}}.}

\item{data}{New data frame (train/test/future batches).}

\item{unseen}{How to handle unseen factor levels in \code{data}:
\code{"warn_na"} (default; convert to \code{NA} with a warning) or \code{"error"} (stop).}
}
\value{
\code{list(formula = spec$formula, data = coerced_data)}
}
\description{
Coerces new data to the types/levels locked in \code{spec} so that
\code{model.matrix(spec$formula, data)} yields the same columns and order
every time, even if some factor levels are absent in the new batch.
}
\examples{
# spec <- bigexp_terms(y ~ X1 + X2 + G, train)
# new_in <- bigexp_prepare(spec, newdata)
# fit <- some_model(new_in$formula, data = new_in$data, ...)
}
