% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_distances.R
\name{calculate_nearest_distances}
\alias{calculate_nearest_distances}
\title{Calculate nearest distances between cell types}
\usage{
calculate_nearest_distances(
  spatial_data,
  reference_type,
  target_types,
  x_col = "pxl_row_in_fullres",
  y_col = "pxl_col_in_fullres",
  id_col = "barcode",
  type_col = "Epi_strom"
)
}
\arguments{
\item{spatial_data}{A data frame containing spatial coordinates and cell type info}

\item{reference_type}{The reference cell type to calculate distances from}

\item{target_types}{Vector of target cell types to calculate distances to}

\item{x_col}{Column name for x-coordinates}

\item{y_col}{Column name for y-coordinates}

\item{id_col}{Column name for cell identifiers}

\item{type_col}{Column name for cell type information}
}
\value{
A data frame with nearest distances for each reference cell
}
\description{
Calculate nearest distances between cell types
}
\examples{
calculate_nearest_distances(posi, reference_type="Macrophage",
                 target_types=c("Epithelial_cells_A","Epithelial_cells_B",
                 "Epithelial_cells_C","Epithelial_cells_D"),
                 id_col = "Newbarcode",
                 type_col = "celltype_ABCDepi")
}
