#' Compute Gumbel Copula Parameter from Kendall's Tau
#'
#' Computes the Gumbel-Hougaard copula dependence parameter based on Kendall's tau.
#'
#' @param tau Numeric, Kendall's tau correlation coefficient.
#' @return Numeric, estimated Gumbel copula parameter.
#' @importFrom rootSolve uniroot.all
#' @export
#'
#' @examples GH.theta(mean(cor(cbind(u[[1]], u[[2]], u[[3]]), method = "kendall")))
#'
GH.theta <- function(tau){
  GH.tau <- function(theta){1 - (1/theta) - tau}
  theta_gum <- rootSolve::uniroot.all(GH.tau, c(1, 100))
  return(theta_gum)
}
