% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Insulation.R
\docType{data}
\name{Insulation}
\alias{Insulation}
\title{Insulation and energy}
\format{
A data frame with 10 rows (each house) and 2 columns:
\describe{
  \item{Before}{Energy consumption before adding insulation, in MWh}
  \item{After}{Energy consumption after adding insulation, in MWh}
}
}
\source{
D. J. Hand, F. Daly, A. D. Lunn, K. J. McConway, and E. Ostrowski (1994) 
A Handbook of Small Data Sets, London: Chapman and Hall. Dataset 86.
}
\usage{
data(Insulation)
}
\description{
Energy consumption before and after adding insulation.
}
\examples{
with(Insulation, hist(Before - After), xlab = "Energy reduction (MWh)")

}
\references{
Originally from: The Open University. 1983. 
\emph{MDST242 Statistics in Society, Unit A0: Introduction.} 
The Open University.
}
\keyword{datasets}
