#' Obstructive sleep apnea (OSA)
#'
#' Sleeping information for adults with Down Syndrome.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 60 rows (each patient) and 7 columns:
#' \describe{
#'   \item{ID}{An identifier}
#'   \item{Age}{The age of the patient, in years}
#'   \item{Gender}{The gender of the patient; one of \code{1} (male) or \code{2} (female)}
#'   \item{BMI}{The BMI of the patient}
#'   \item{Neck}{The neck circumference of the patient, in cm}
#'   \item{REI}{The Respiratory Event Index for the patient}
#'   \item{SAOS}{The SAOS score; one of \code{Severe}, \code{Moderate} or \code{Low}}
#' }
#' @source 
#' de Carvalho, Anderson Albuquerque, Fabio Ferreira Amorim, Levy Aniceto Santana, Karlo Jozefo Quadros de Almeida, Alfredo Nicodemos Cruz Santana, and Francisco de Assis Rocha Neves. 2020.
#' STOP-Bang Questionnaire Should Be Used in All Adults with Down Syndrome 
#' to Screen for Moderate to Severe Obstructive Sleep Apnea.
#' \emph{PloS ONE} \bold{15} (5): e0232596.
#' 
#' The data are given at:
#' <https://figshare.com/articles/dataset/Raw_database_and_statistical_analysis_results-STOP-Bang_questionnaire_should_be_used_in_all_adults_with_Down_Syndrome_to_screen_for_moderate_to_severe_obstructive_sleep_apnea_OSA_/9788903/1>
#' 
#' @usage 
#' data(OSA)
#' 
#' @examples
#' plot(BMI ~ factor(SAOS), data = OSA, xlab = "SAOS score", ylab = "BMI")

"OSA"
