% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_by_sample.R
\name{missing_by_sample}
\alias{missing_by_sample}
\title{Vizualise missing data per sample, remove samples above a missing data cutoff}
\usage{
missing_by_sample(vcfR, popmap = NULL, cutoff = NULL)
}
\arguments{
\item{vcfR}{a vcfR object}

\item{popmap}{if specifies, it must be a two column dataframe with columns names 'id' and 'pop'.
IDs must match the IDs in the vcfR object}

\item{cutoff}{a numeric value between 0-1 specifying the maximum proportion of missing data
allowed in a sample to be retained for downstream analyses}
}
\value{
if 'cutoff' is not specified, will return a dataframe containing the average
depth and proportion missing data in each sample. If 'cutoff' is specified, the samples
falling above the missing data cutoff
will be removed, and the filtered vcfR object will be returned.
}
\description{
This function can be run in two ways: 1) Without 'cutoff' specified. This will vizualise the
amount of missing data in each sample across a variety of potential missing data cutoffs.
Additionally, it will show you a dotplot ordering the amount of overall missing data
in each sample. Based on these visualizations, you can make an informed decision on what
you think might be an optimal cutoff to remove samples that are missing too much data to
be retained for downstream analyses. 2) with 'cutoff' specified.
This option will show you the dotplot with the cutoff you set, and then
remove samples above the missing data cutoff you set, and return the filtered vcf to you.
}
\details{
Note: This decision is highly project specific, but these visualizations should help
you get a feel for how very low data samples cannot be rescued simply by a missing
data SNP filter. If you want to remove specific samples from your vcf that cannot
be specified with a simple cutoff refer to this great
\href{https://knausb.github.io/vcfR_documentation/sequence_coverage.html}{tutorial}
which is the basis for the code underlying this function.
}
\examples{
missing_by_sample(vcfR = SNPfiltR::vcfR.example)
missing_by_sample(vcfR = SNPfiltR::vcfR.example, cutoff = .7)
}
