% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basisFunInitAndCompute.R
\name{check_basisfun_opts}
\alias{check_basisfun_opts}
\title{Check basis function parameters}
\usage{
check_basisfun_opts(basisFunctionsUsed, dimension, opts_BasisFun = list())
}
\arguments{
\item{basisFunctionsUsed}{Character. Type of basis function to use.
One of: "inducing points", "RFF", "Discrete FF", "filling FF", "custom cosines".}

\item{dimension}{Integer. The dimension of the input space (typically \eqn{[\mathbf{x}, t]}).}

\item{opts_BasisFun}{List. Options specific to the chosen basis function.
Users can refer to the documentation of specific basis function initialization functions
(e.g., \code{\link{initialize_basisfun_inducingpt}}, \code{\link{initialize_basisfun_RFF}},
\code{\link{initialize_basisfun_fillingRFF}}, \code{\link{initialize_basisfun_discreteFF}}, etc.) for details on the available options.}
}
\value{
A completed list of options specific to the chosen basis function.
}
\description{
Checks and completes the parameter list for a given basis function type.
}
\keyword{internal}
