% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplicaCV.R
\name{simplicaCV}
\alias{simplicaCV}
\title{Test Simplivariate Components with Cross-Validation Pattern Selection}
\usage{
simplicaCV(
  foundObject,
  df,
  patternFunctions = defaultPatternFunctions(),
  patternFitters = defaultPatternFitters(),
  preferenceOrder = names(patternFunctions),
  nRepeats = 40,
  testFraction = 0.2,
  minCellsForModels = 25,
  parsimonyMargin = 0.05,
  requireFitters = TRUE,
  updateObject = TRUE,
  verbose = FALSE,
  ignoreNaComponents = TRUE
)
}
\arguments{
\item{foundObject}{A simplica object containing Simplivariate Components}

\item{df}{Data frame or matrix with the original data}

\item{patternFunctions}{List of pattern functions to evaluate (default: defaultPatternFunctions())}

\item{patternFitters}{List of pattern fitting functions (default: defaultPatternFitters())}

\item{preferenceOrder}{Character vector specifying preference order for pattern selection (default: names(patternFunctions))}

\item{nRepeats}{Integer, number of cross-validation repeats (default: 40)}

\item{testFraction}{Numeric, fraction of data to use for testing (default: 0.2)}

\item{minCellsForModels}{Integer, minimum number of cells required for model fitting (default: 25)}

\item{parsimonyMargin}{Numeric, margin for parsimony-based model selection (default: 0.05)}

\item{requireFitters}{Logical, whether fitters are required for all patterns (default: TRUE)}

\item{updateObject}{Logical, whether to update and return the input object (default: TRUE)}

\item{verbose}{Logical, whether to print progress messages (default: FALSE)}

\item{ignoreNaComponents}{Logical, whether to skip components with NA patterns (default: TRUE)}
}
\value{
If \code{updateObject = TRUE}, returns the input \code{simplica} object
with two new fields:
\describe{
\item{\code{componentPatternsUpdated}}{Character vector with the selected
pattern per component after cross-validation. If a component is skipped or empty,
the entry is \code{NA}.}
\item{\code{componentAudit}}{Data frame containing detailed cross-validation
results for each component, with the following columns:
\describe{
\item{\code{componentId}}{Numeric ID of the component.}
\item{\code{originalPattern}}{Pattern label originally assigned.}
\item{\code{selectedPattern}}{Pattern chosen after CV-based evaluation.}
\item{\code{reason}}{Explanation of why a pattern was selected or skipped.}
\item{\code{nRows}, \code{nCols}, \code{nCells}}{Dimensions of the component.}
\item{\code{nRepeats}, \code{testFraction}, \code{parsimonyMargin}}{CV settings used.}
\item{\code{cvMean_<pattern>}}{Mean RMSE over CV folds for each tested pattern.}
\item{\code{cvSd_<pattern>}}{Standard deviation of RMSE across CV folds.}
\item{\code{winFrac_<pattern>}}{Fraction of CV repeats where the pattern was the best performer.}
}}
}

If \code{updateObject = FALSE}, returns a list with the same two elements
(\code{componentPatternsUpdated}, \code{componentAudit}).
}
\description{
This function performs cross-validation-based pattern testing for Simplivariate Components
in a SIMPLICA object. It evaluates different pattern functions using cross-validation
and selects the best performing pattern for each component. Fitters are required
for all patterns with no fallback options.
}
\details{
The function performs the following steps:
\itemize{
\item Validates the input simplica object and data dimensions
\item Checks that all pattern functions have corresponding fitters
\item For each simplivariate component, performs cross-validation pattern evaluation
\item Selects the best performing pattern based on RMSE and parsimony
\item Updates component patterns and provides detailed test information
}
}
