% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitnessForOneComponent.R
\name{fitnessForOneComponent}
\alias{fitnessForOneComponent}
\title{Compute best pattern-based fitness for a single Simplivariate Component}
\usage{
fitnessForOneComponent(mat, dfMean, patternFunctions, penalty)
}
\arguments{
\item{mat}{A numeric matrix (the component)}

\item{dfMean}{Overall mean of the full data matrix}

\item{patternFunctions}{Named list of functions for structure types}

\item{penalty}{Named numeric vector of penalties per pattern type}
}
\value{
Numeric fitness value (higher is better)
}
\description{
Compute best pattern-based fitness for a single Simplivariate Component
}
\examples{
m <- matrix(rnorm(100, mean = 10), nrow = 10)
f <- fitnessForOneComponent(m, mean(m), defaultPatternFunctions(),
               c(constant = 0, additive = 1.0, multiplicative = 0))
}
