% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitness.R
\name{fitness}
\alias{fitness}
\title{Fitness function with automatic pattern selection per Simplivariate Component}
\usage{
fitness(
  string,
  df,
  dfMean,
  penalty,
  patternFunctions = defaultPatternFunctions(),
  returnPatterns = FALSE,
  ...
)
}
\arguments{
\item{string}{Vector with length nrow(df) + ncol(df): component labels for rows and columns (in this order).}

\item{df}{Numeric matrix: full data.}

\item{dfMean}{Scalar: global mean of df.}

\item{penalty}{Named vector with penalty weights per pattern.}

\item{patternFunctions}{Named list of functions returning pattern-based approximations.}

\item{returnPatterns}{Logical: if TRUE, also returns chosen pattern per component.}

\item{...}{Additional arguments passed to the GA functions}
}
\value{
Either total fitness (numeric), or list(fitness, componentPatterns) if returnPatterns = TRUE.
}
\description{
Fitness function with automatic pattern selection per Simplivariate Component
}
