% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{predict_cdf_tree}
\alias{predict_cdf_tree}
\title{Predict conditional CDF values from an SFHNV tree}
\usage{
predict_cdf_tree(tree, observations, d_values)
}
\arguments{
\item{tree}{An object produced by \code{\link[=NW_Tree]{NW_Tree()}}.}

\item{observations}{Data frame of new observations containing the same features
as the training data.}

\item{d_values}{Either a scalar demand threshold applied to all observations,
or a numeric vector with one value per observation.}
}
\value{
Numeric vector of CDF values.
}
\description{
Predict conditional CDF values from an SFHNV tree
}
\examples{
data <- data.frame(x = rnorm(50), D = rnorm(50), Q = rnorm(50))
tree <- NW_Tree(data, min_size = 10, max_depth = 3)
predict_cdf_tree(tree, data, d_values = 0)
}
