% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxpro.R
\name{maxpro.optim}
\alias{maxpro.optim}
\title{Optimize a design based on the maximum projection criterion}
\usage{
maxpro.optim(D.ini, iteration = 10)
}
\arguments{
\item{D.ini}{the initial design.}

\item{iteration}{number iterations for L-BFGS-B.}
}
\value{
\item{design}{optimized design.}
\item{D.ini}{initial design.}
}
\description{
This function optimizes a design by continuous optimization based on maximum projection criterion (Joseph, V. R., Gul, E., & Ba, S. 2015).
}
\details{
\code{maxpro.optim} optimizes a design by L-BFGS-B algorithm (Liu and Nocedal 1989) based on the maximum projection criterion \code{\link{maxpro.crit}}.
}
\examples{
n = 20
p = 3
D = maxproLHD(n, p)$design
D = maxpro.optim(D)$design

}
\references{
Liu, D. C., & Nocedal, J. (1989). On the limited memory BFGS method for large scale optimization. Mathematical programming, 45(1), 503-528.

Joseph, V. R., Gul, E., & Ba, S. (2015). Maximum projection designs for computer experiments. Biometrika, 102(2), 371-380.
}
