% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_BarPlot.R
\name{do_BarPlot}
\alias{do_BarPlot}
\title{Create Bar Plots.}
\usage{
do_BarPlot(
  sample,
  group.by,
  order = FALSE,
  add.n = FALSE,
  add.n.face = "bold",
  add.n.expand = c(0, 1.15),
  add.n.size = 4,
  order.by = NULL,
  split.by = NULL,
  facet.by = NULL,
  position = "stack",
  font.size = 14,
  font.type = "sans",
  legend.position = "bottom",
  legend.title = NULL,
  legend.ncol = NULL,
  legend.nrow = NULL,
  legend.byrow = FALSE,
  axis.text.x.angle = 45,
  xlab = NULL,
  ylab = NULL,
  colors.use = NULL,
  colorblind = FALSE,
  flip = FALSE,
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  plot.grid = FALSE,
  grid.color = "grey75",
  grid.type = "dashed",
  plot.title.face = "bold",
  plot.subtitle.face = "plain",
  plot.caption.face = "italic",
  axis.title.face = "bold",
  axis.text.face = "plain",
  legend.title.face = "bold",
  legend.text.face = "plain",
  strip.text.face = "bold",
  return_data = FALSE
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata column to compute the counts of. Has to be either a character or factor column.}

\item{order}{\strong{\code{\link[base]{logical}}} | Whether to order the results in descending order of counts.}

\item{add.n}{\strong{\code{\link[base]{logical}}} | Whether to add the total counts on top of each bar.}

\item{add.n.face}{\strong{\code{\link[base]{character}}} | Font face of the labels added by \strong{\code{add.n}}.}

\item{add.n.expand}{\strong{\code{\link[base]{numeric}}} | Vector of two numerics representing the start and end of the scale. Minimum should be 0 and max should be above 1. This basically expands the Y axis so that the labels fit when \strong{\code{flip = TRUE}}.
\itemize{
\item \emph{\code{stack}}: Set the bars side by side, displaying the total number of counts. Uses \link[ggplot2]{position_stack}.
\item \emph{\code{fill}}: Set the bars on top of each other, displaying the proportion of counts from the total that each group represents. Uses \link[ggplot2]{position_fill}.
}}

\item{add.n.size}{\strong{\code{\link[base]{numeric}}} | Size of the labels}

\item{order.by}{\strong{\code{\link[base]{character}}} | When \strong{\code{split.by}} is used, value of \strong{\code{group.by}} to reorder the columns based on its value.}

\item{split.by}{\strong{\code{\link[base]{character}}} | Metadata column to split the values of group.by by. If not used, defaults to the active idents.}

\item{facet.by}{\strong{\code{\link[base]{character}}} | Metadata column to gather the columns by. This is useful if you have other overarching metadata.}

\item{position}{\strong{\code{\link[base]{character}}} | Position function from \pkg{ggplot2}. Either stack or fill.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{legend.ncol}{\strong{\code{\link[base]{numeric}}} | Number of columns in the legend.}

\item{legend.nrow}{\strong{\code{\link[base]{numeric}}} | Number of rows in the legend.}

\item{legend.byrow}{\strong{\code{\link[base]{logical}}} | Whether the legend is filled by row or not.}

\item{axis.text.x.angle}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}

\item{xlab, ylab}{\strong{\code{\link[base]{character}}} | Titles for the X and Y axis.}

\item{colors.use}{\strong{\code{\link[SCpubr]{named_vector}}} | Named vector of valid color representations (either name of HEX codes) with as many named colors as unique values of group.by. If group.by is not provided, defaults to the unique values of \link[Seurat]{Idents}. If not provided, a color scale will be set by default.}

\item{colorblind}{\strong{\code{\link[base]{logical}}} | Whether to use colorblind-friendly colors for categorical variables. In place when \code{colors.use} is not used. Allows for a maximum of 85 different classes within a categorical variable.}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{plot.grid}{\strong{\code{\link[base]{logical}}} | Whether to plot grid lines.}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the plot. In heatmaps, color of the border of the cells.}

\item{grid.type}{\strong{\code{\link[base]{character}}} | One of the possible linetype options:
\itemize{
\item \emph{\code{blank}}.
\item \emph{\code{solid}}.
\item \emph{\code{dashed}}.
\item \emph{\code{dotted}}.
\item \emph{\code{dotdash}}.
\item \emph{\code{longdash}}.
\item \emph{\code{twodash}}.
}}

\item{plot.title.face, plot.subtitle.face, plot.caption.face, axis.title.face, axis.text.face, legend.title.face, legend.text.face}{\strong{\code{\link[base]{character}}} | Controls the style of the font for the corresponding theme element.  One of:
\itemize{
\item \emph{\code{plain}}: For normal text.
\item \emph{\code{italic}}: For text in itallic.
\item \emph{\code{bold}}: For text in bold.
\item \emph{\code{bold.italic}}: For text both in itallic and bold.
}}

\item{strip.text.face}{\strong{\code{\link[base]{character}}} | Controls the style of the font for the strip text.  One of:
\itemize{
\item \emph{\code{plain}}: For normal text.
\item \emph{\code{italic}}: For text in itallic.
\item \emph{\code{bold}}: For text in bold.
\item \emph{\code{bold.italic}}: For text both in itallic and bold.
}}

\item{return_data}{\strong{\code{\link[base]{logical}}} | Returns a data.frame with the count and proportions displayed in the plot.}
}
\value{
A ggplot2 object containing a Bar plot.
}
\description{
Create Bar Plots.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_BarPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Basic bar plot, horizontal.
    p1 <- SCpubr::do_BarPlot(sample = sample,
                             group.by = "seurat_clusters",
                             legend.position = "none",
                             plot.title = "Number of cells per cluster")

    # Split by a second variable.
    sample$modified_orig.ident <- sample(x = c("Sample_A", "Sample_B", "Sample_C"),
                                         size = ncol(sample),
                                         replace = TRUE,
                                         prob = c(0.2, 0.7, 0.1))

    p <- SCpubr::do_BarPlot(sample,
                            group.by = "seurat_clusters",
                            split.by = "modified_orig.ident",
                            plot.title = "Number of cells per cluster in each sample",
                            position = "stack")


  } else if (base::isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
