% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_strategies.R
\name{threshold_strategies}
\alias{threshold_strategies}
\title{Subset an rtrack_strategies object.}
\usage{
threshold_strategies(strategies, threshold = NULL)
}
\arguments{
\item{strategies}{An \code{rtrack_strategies} object as generated by
\code{\link{call_strategy}}.}

\item{threshold}{A numeric value between 0 and 1.}
}
\value{
An \code{rtrack_strategies} object including only above-threshold
  calls. In addition, the component \code{thresholded} is set to \code{TRUE}
  if thresholding was performed.
}
\description{
Subsets strategy calls based on a threshold.
}
\details{
For strategy-calling algorithms yielding a confidence score (such as
\code{\link{call_strategy}}), a value between 0 and 1 will return a new
\code{rtrack_strategies} object only including calls with a confidence score
above the given threshold.
}
\examples{
require(Rtrack)
track_file <- system.file("extdata", "Track_1.tab", package = "Rtrack")
arena_description <- system.file("extdata", "Arena.txt", package = "Rtrack")
arena <- read_arena(arena_description)
path <- read_path(track_file, arena, track.format = "raw.tab")
metrics <- calculate_metrics(path, arena)
strategies <- call_strategy(metrics)
# Inspect the strategy call (minimal experiment only has one track)
strategies$calls
# Thresholding at 0.7 will retain the track (confidence = 0.72)
strategies = threshold_strategies(strategies, threshold = 0.7)
strategies$calls
# Thresholding at 0.8 will discard the track, still returning an (empty) rtrack_strategies object
strategies = threshold_strategies(strategies, threshold = 0.8)
strategies$calls

}
