% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dalaplace}
\alias{dalaplace}
\title{Returns density from Asymmetric Laplace Distribution}
\usage{
dalaplace(x, m = 0, al = 1, ar = 1)
}
\arguments{
\item{x}{(numeric) - value in the range \eqn{(-\infty, \infty)} to evaluate
the density.}

\item{m}{(numeric) - location parameter.}

\item{al, ar}{(numeric) - scale parameters. Must be in the range
\eqn{(0, \infty)}.}
}
\value{
a vector containing the values for the densities.
}
\description{
The \code{dalaplace} returns the density at point x for the
Asymmetric Laplace distribution with parameters \eqn{a*} and \eqn{m}.
}
\details{
The Asymmetric Laplace distribution is a distribution controlled
by three parameters, with formula:
\deqn{f(x;a_l,a_r,m) =
\frac{1}{A} e^{-|\frac{x-m}{a_l}| }, x < m
}
\deqn{f(x;a_l,a_r,m) =
\frac{1}{A} e^{-|\frac{x-m}{a_r}| }, x > m
}
with:
\deqn{A = a_l + a_r}
where \eqn{a*} are scale parameters, and \eqn{m} is a location parameter.
It is basically derived from the Asymmetric Exponential Power distribution
by setting \eqn{b_l = b_r = b}.
}
