% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{update_b}
\alias{update_b}
\title{Update class means}
\usage{
update_b(beta, Omega, z, m, Sigma_b_0_inv, mu_b_0)
}
\arguments{
\item{beta}{[\code{matrix(nrow = P_r, ncol = N)}]\cr
The matrix of the decider-specific coefficient vectors.}

\item{Omega}{[\code{matrix(nrow = P_r * P_r, ncol = C)}]\cr
The matrix of vectorized class covariance matrices as columns.}

\item{z}{[\code{numeric(N)}]\cr
The decider class allocations.}

\item{m}{[\code{numeric(C)}]\cr
The vector of current class frequencies.}

\item{Sigma_b_0_inv}{[\code{matrix(P_r, P_r)}]\cr
The prior precision of the class mean.}

\item{mu_b_0}{[\code{numeric(P_r)}]\cr
The mean vector of the normal prior for each \code{b_c}.}
}
\value{
A matrix of updated means for each class in columns.
}
\description{
Update class means
}
\examples{
N <- 100
b <- cbind(c(0, 0), c(1, 1))
Omega <- matrix(c(1, 0.3, 0.3, 0.5, 1, -0.3, -0.3, 0.8), ncol = 2)
z <- c(rep(1, N / 2), rep(2, N / 2))
m <- as.numeric(table(z))
beta <- sapply(
  z, function(z) oeli::rmvnorm(n = 1, b[, z], matrix(Omega[, z], 2, 2))
)
update_b(
  beta = beta, Omega = Omega, z = z, m = m,
  Sigma_b_0_inv = diag(2), mu_b_0 = c(0, 0)
)

}
\keyword{gibbs_sampler}
