% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{model_selection}
\alias{model_selection}
\alias{print.RprobitB_model_selection}
\title{Compare fitted models}
\usage{
model_selection(
  ...,
  criteria = c("npar", "LL", "AIC", "BIC"),
  add_form = FALSE
)

\method{print}{RprobitB_model_selection}(x, digits = 2, ...)
}
\arguments{
\item{...}{One or more objects of class \code{RprobitB_fit}.}

\item{criteria}{[\code{character()}]\cr
One or more of the following:
\itemize{
\item \code{"npar"} for the number of model parameters (see \code{\link{npar}}),
\item \code{"LL"} for the log-likelihood value (see \code{\link{logLik}}),
\item \code{"AIC"} for the AIC value (see \code{\link{AIC}}),
\item \code{"BIC"} for the BIC value (see \code{\link{BIC}}),
\item \code{"WAIC"} for the WAIC value (also shows its standard error
\code{sd(WAIC)} and the number \code{pWAIC} of effective model parameters,
see \code{\link{WAIC}}),
\item \code{"MMLL"} for the marginal model log-likelihood,
\item \code{"BF"} for the Bayes factor,
\item \code{"pred_acc"} for the prediction accuracy (see \code{\link{pred_acc}}).
}}

\item{add_form}{[\code{logical(1)}]\cr
Add the model formulas?}

\item{x}{An object of class \code{RprobitB_model_selection}.}

\item{digits}{[\code{integer(1)}]\cr
The number of digits.}
}
\value{
A \code{data.frame}, criteria in columns, models in rows.
}
\description{
This function returns a table with several criteria for model comparison.
}
\details{
See the vignette on model selection for more details.
}
