% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB_data.R, R/plotting.R
\name{RprobitB_data}
\alias{RprobitB_data}
\alias{print.RprobitB_data}
\alias{summary.RprobitB_data}
\alias{print.summary.RprobitB_data}
\alias{plot.RprobitB_data}
\title{Create object of class \code{RprobitB_data}}
\usage{
RprobitB_data(
  data,
  choice_data,
  N,
  T,
  J,
  P_f,
  P_r,
  alternatives,
  ordered,
  ranked,
  base,
  form,
  re,
  ASC,
  effects,
  standardize,
  simulated,
  choice_available,
  true_parameter,
  res_var_names
)

\method{print}{RprobitB_data}(x, ...)

\method{summary}{RprobitB_data}(object, ...)

\method{print}{summary.RprobitB_data}(x, ...)

\method{plot}{RprobitB_data}(x, by_choice = FALSE, alpha = 1, position = "dodge", ...)
}
\arguments{
\item{data}{[\code{list}]\cr
A list with the choice data.
\itemize{
\item The list has \code{N} elements.
\item Each element is a list with two elements, \code{X} and \code{y}, which are
the covariates and decisions for a decision maker. More precisely:
\itemize{
\item \code{X} is a list of \code{T} elements, where each element is a matrix
of dimension \code{J}x(\code{P_f}+\code{P_r}) and contains the
characteristics for one choice occasion.
\item \code{y} is a vector of length \code{T} and contains the labels for the
chosen alternatives.
}
}}

\item{choice_data}{[\code{data.frame}]\cr
Choice data in wide format, where each row represents one choice occasion.}

\item{N}{[\code{integer(1)}]\cr
The number of decision makers.}

\item{T}{[\code{integer(1)} | \code{integer(N)}]\cr
The number of choice occasions or a vector of decider-specific choice
occasions of length \code{N}.}

\item{J}{[\code{integer(1)}]\cr
The number >= 2 of choice alternatives.}

\item{P_f}{[\code{integer(1)}]\cr
The number of covariates connected to a fixed coefficient.}

\item{P_r}{[\code{integer(2)}]\cr
The number of covariates connected to a random coefficient.}

\item{alternatives}{[\code{character()}]\cr
The names of the choice alternatives. If not specified, the choice set is
defined by the observed choices.

If \code{ordered = TRUE}, \code{alternatives} is assumed to be specified with
the alternatives ordered from worst to best.}

\item{ordered}{[\code{logical(1)}]\cr
If \code{TRUE}, the choice set \code{alternatives} is assumed to be ordered
from worst to best.}

\item{ranked}{[\code{logical(1)}]\cr
Are the alternatives ranked?}

\item{base}{[\code{character(1)}]\cr
The name of the base alternative for covariates that are not
alternative specific (i.e. type 2 covariates and ASCs).

Ignored and set to \code{NULL} if the model has no alternative specific
covariates (e.g. in the ordered probit model).

By default, \code{base} is the last element of \code{alternatives}.}

\item{form}{[\code{formula}]\cr
A model description with the structure \code{choice ~ A | B | C}, where
\itemize{
\item \code{choice} is the name of the dependent variable (the choices),
\item \code{A} are names of alternative and choice situation specific
covariates with a coefficient that is constant across alternatives,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}

Multiple covariates (of one type) are separated by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model.
They can be removed by adding \code{+0} in the second spot.

In the ordered probit model (\code{ordered = TRUE}), the \code{formula}
object has the simple structure \code{choice ~ A}. ASCs are not estimated.}

\item{re}{[\code{character()} | \code{NULL}]\cr
Names of covariates with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the ASCs, include \code{"ASC"} in \code{re}.}

\item{ASC}{[\code{logical(1)}]\cr
Does the model have ASCs?}

\item{effects}{[\code{data.frame}]\cr
A data frame with the effect names and booleans indicating whether
they are connected to random effects.}

\item{standardize}{[\code{character()} | \code{"all"}]\cr
Names of covariates that get standardized.

Covariates of type 1 or 3 have to be addressed by
\code{<covariate>_<alternative>}.

If \code{standardize = "all"}, all covariates get standardized.}

\item{simulated}{[\code{logical(1)}]\cr
Is \code{data} simulated?}

\item{choice_available}{[\code{logical(1)}]\cr
Does \code{data} contain observed choices?}

\item{true_parameter}{[\code{RprobitB_parameters}]\cr
True parameters for the data generating process.}

\item{res_var_names}{[\code{list}]\cr
Reserved variable names in \code{choice_data}.}

\item{x}{An object of class \code{RprobitB_data}.}

\item{...}{Currently not used.}

\item{by_choice}{[\code{logical(1)}]\cr
Group the covariates by the chosen alternatives?}

\item{alpha, position}{Passed to \code{\link[ggplot2]{ggplot}}.}
}
\value{
An object of class \code{RprobitB_data}.
}
\description{
This function constructs an object of class \code{RprobitB_data}.
}
\examples{
data <- simulate_choices(
  form = choice ~ cost | 0,
  N = 100,
  T = 10,
  J = 2,
  alternatives = c("bus", "car"),
  true_parameter = list("alpha" = -1)
)
plot(data, by_choice = TRUE)
}
\keyword{internal}
