% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stem_leaf_display.R
\name{stem_leaf_display}
\alias{stem_leaf_display}
\title{stem_leaf_display}
\usage{
stem_leaf_display(
  x = NULL,
  title = NULL,
  unit = 1,
  m = 1,
  min_val = NULL,
  max_val = NULL,
  outliers = TRUE,
  depths = FALSE,
  col_width = 4,
  row_height = 0.5,
  font_sz = 11,
  heading_color = "black"
)
}
\arguments{
\item{x}{The named list of numeric vectors from which stem and leaf displays are provided.}

\item{title}{A string that sets the title.}

\item{unit}{Leaf unit, as a power of 10 (e.g. 100, 0.01). The default is 1.}

\item{m}{Number of parts (1, 2, 5) into which each stem will be separated. The default is 1.}

\item{min_val}{Optional numeric that sets the smallest non-outlying value.}

\item{max_val}{Optional numeric that sets the largest non-outlying value.}

\item{outliers}{A logical which if \code{TRUE} (the default), outliers are placed on LO and HI stems}

\item{depths}{A logical which if \code{TRUE} (the default), print a column of "depths" to the left of the stems}

\item{col_width}{A numeric that sets the display column widths in cm. The default is 4, which
works when 'depths' is \code{FALSE}. You may need to increase this value to avoid cutting off wide leaf values.}

\item{row_height}{A numeric that sets the display row height in cm. The default is 0.5. You may need to
decrease this value for smaller font sizes and longer stem values.}

\item{font_sz}{A numeric that sets the display's font size. The default is 11.}

\item{heading_color}{A string that sets the heading's color in name or hex. The default is "black".}
}
\value{
A ggplot2 class object
}
\description{
Function is a wrapper around \code{aplpack::stem.leaf} that provides one or more stem and leaf display(s).

Function accepts a named list of numeric vectors from which stem and leaf displays
  are provided.
}
\examples{
library(grid)
library(gtable)
library(ggplotify)
library(ggplot2)
library(aplpack)
library(RplotterPkg)

# stem and leaf for marathon times of women across ages
marathon_times_lst <- list(
  "age_20" = RplotterPkg::boston_marathon[age == 20,]$time,
  "age_30" = RplotterPkg::boston_marathon[age == 30,]$time,
  "age_40" = RplotterPkg::boston_marathon[age == 40,]$time,
  "age_50" = RplotterPkg::boston_marathon[age == 50,]$time,
  "age_60" = RplotterPkg::boston_marathon[age == 60,]$time
)
# display stem and leaf of women times across ages
RplotterPkg::stem_leaf_display(
  x = marathon_times_lst,
  title = "Women times(min) in Boston marathon",
  heading_color = "#FF5500"
)

}
