% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_density_ridge_plot.R
\name{create_density_ridge_plot}
\alias{create_density_ridge_plot}
\title{create_density_ridge_plot}
\usage{
create_density_ridge_plot(
  df = NULL,
  variables = NULL,
  plot_heights = 3.5,
  plot_widths = 24,
  bw = "nrd0",
  adjust = 1,
  kernel = "gaussian",
  n = 512,
  na.rm = TRUE,
  title = NULL,
  title_fontsz = 14,
  x_title = NULL,
  rot_x_tic_angle = 0,
  density_linewdth = 1,
  density_color = "black",
  density_fill = "gray",
  density_alpha = 0.4,
  x_limits = NULL,
  x_major_breaks = waiver(),
  x_minor_breaks = waiver(),
  x_labels = waiver(),
  y_limits = NULL,
  y_major_breaks = waiver(),
  y_minor_breaks = waiver(),
  y_show_axis = FALSE,
  axis_text_size = 11
)
}
\arguments{
\item{df}{The source data frame from which the densities are plotted.}

\item{variables}{A required string vector that names the x axis variables from 'df' for plotting their densities.}

\item{plot_heights}{A numeric that sets the plot height in centimeters for each variable in 'variables'.
The default is 3.5 centimeters in height for each plot.}

\item{plot_widths}{A numeric that sets the plot width in centimeters for each variable in 'variables'.
The default is 24 centimeters in width for each plot.}

\item{bw}{A string or numeric that sets the smoothing bandwidth to be used with the KDE function.}

\item{adjust}{A numeric that adjusts 'bw' since the actual bandwidth is computed as \code{adjust*bw}.}

\item{kernel}{A string that set the type of Kernel Density Estimation (KDE). Acceptable values are "gaussian",
"rectangular", "triangular", "epanechnikov", "biweight", "cosine" or "optcosine".}

\item{n}{The number of equally spaced points at which the density is to be estimated. This should be a power of two.}

\item{na.rm}{A logical which if \code{TRUE}, missing values are removed from 'df'. If \code{FALSE} any missing
values cause an error.}

\item{title}{A string that sets the overall title.}

\item{title_fontsz}{A numeric that sets the title's font size. The default is 14.}

\item{x_title}{A string that sets the x axis title. If NULL (the default)  then the x axis title does not appear.}

\item{rot_x_tic_angle}{A numeric that sets the angle of rotation for the x tic labels. When x tic labels are long,
a value of 40 for this argument usually works well.}

\item{density_linewdth}{A numeric that sets the density line width.}

\item{density_color}{A string that sets the color for the density line.}

\item{density_fill}{A string that sets the color for the density fill.}

\item{density_alpha}{A numeric that sets the alpha value for 'density_fill'.}

\item{x_limits}{A numeric 2 element vector or function that sets the minimum and maximum for the x axis. Use NA to
refer to the existing minimum and maximum.}

\item{x_major_breaks}{A numeric vector or function that sets the major tic locations along the x axis.}

\item{x_minor_breaks}{A numeric vector or function that sets the minor tic locations along the x axis.}

\item{x_labels}{A character vector or function giving x axis tic labels.  Must be the same length as 'x_major_breaks'.}

\item{y_limits}{A numeric 2 element vector or function that sets the minimum and maximum for the y axis.  Use NA to
refer to the existing minimum and maximum.}

\item{y_major_breaks}{A numeric vector or function that sets the major tic locations along the y axis.}

\item{y_minor_breaks}{A numeric vector or function that sets the minor tic locations along the y axis.}

\item{y_show_axis}{A logical which if TRUE will display the y-axis density for each variable.}

\item{axis_text_size}{A numeric that sets the font size along the axis'. Default is 11.}
}
\value{
A ggplot class object.
}
\description{
Function creates ggplot2 based plots stacked vertically (also known as ridge or raincloud plots).
 The function's density arguments mirror most of the arguments available
 from \code{\link{density}} for the Kernel Density Estimation (KDE). See the \code{\link{density}} help page
 for more information.
}
\examples{
library(ggplot2)
library(data.table)
library(grid)
library(gtable)
library(ggplotify)
library(RplotterPkg)

RplotterPkg::create_density_ridge_plot(
  df = RplotterPkg::midwest,
  bw = "sj",
  variables = c("HS_Diploma", "College_Edu", "Prof_Deg", "White", "Black", "Asian"),
  title = "Percent Distribution Among Midwest Counties",
  x_limits = c(0, 100),
  x_major_breaks = seq(0, 100, 10),
  density_fill = "blue",
  density_alpha = 0.5,
  plot_heights = 2.5,
  plot_widths = 18
)

}
\references{
Micah Allen,Davide Poggiali,Kirstie Whitaker,Tom Rhys Marshall,
 Jordy van Langen,Rogier A. Kievit (2021) Raincloud plots: a multi-platform tool for robust data visualization: version 2

Joachim Schork (2021) Ridgeline Plots in R (3 Examples)
}
