% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covariance_fn.R
\name{est_cov}
\alias{est_cov}
\title{Empirical covariance function}
\usage{
est_cov(X, theta = 0.1, plot = FALSE)
}
\arguments{
\item{X}{A data frame where the first column is the numeric time sequence and the remaining
columns are the values of each realisation of the process.}

\item{theta}{Smoothing parameter.}

\item{plot}{Logical: If TRUE, a 3D surface plot of the covariance function is plotted in interactive sessions.}
}
\value{
An \eqn{m \times m} matrix, where \eqn{m} is the number of time points.
Each element represents the estimated value of covariance function for the
corresponding time points. Time points are arranged in ascending order.
}
\description{
Computes the empirical covariance function of a process, for each pair of time points in the
time sequence using M realisations of the process.
}
\details{
The smoothing parameter \code{theta} can help to better visualise changes between
neighbour estimated values.
}
\examples{
\donttest{
#Matrix of empirical covariance estimates of the GHBMP with Hurst function H.
t <- seq(0, 1, by = (1/2)^8)
H <- function(t) {return(0.5 - 0.4 * sin(6 * 3.14 * t))}
#Only 5 realisations of GHBMP are used in this example to reduce the computational time.
X.t <- replicate(5, GHBMP(t, H), simplify = FALSE)
X <- do.call(rbind, lapply(X.t, function(df) df[, 2]))
Data <- data.frame(t, t(X))
cov.mat <- est_cov(Data, theta = 0.2, plot = TRUE)
cov.mat
}
}
\seealso{
\code{\link{cov_GHBMP}}
}
