% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_prediction.R
\name{plot.RiskMap_pred_target_shp}
\alias{plot.RiskMap_pred_target_shp}
\title{Plot Method for RiskMap_pred_target_shp Objects}
\usage{
\method{plot}{RiskMap_pred_target_shp}(x, which_target = "linear_target", which_summary = "mean", ...)
}
\arguments{
\item{x}{An object of class 'RiskMap_pred_target_shp' containing computed targets,
summaries, and associated spatial data.}

\item{which_target}{Character indicating the target type to plot (e.g., "linear_target").}

\item{which_summary}{Character indicating the summary type to plot (e.g., "mean", "sd").}

\item{...}{Additional arguments passed to 'scale_fill_distiller' in 'ggplot2'.}
}
\value{
A \code{ggplot} object showing the plot of the specified predictive target or summary.
}
\description{
Generates a plot of predictive target values or summaries over a shapefile.
}
\details{
This function plots the predictive target values or summaries over a shapefile.
It requires the 'ggplot2' package for plotting and 'sf' objects for spatial data.
}
\seealso{
\code{\link{pred_target_shp}}, \code{\link[ggplot2]{ggplot}}, \code{\link[ggplot2]{geom_sf}},
\code{\link[ggplot2]{aes}}, \code{\link[ggplot2]{scale_fill_distiller}}
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Claudio Fronterre \email{c.fronterr@lancaster.ac.uk}
}
