% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NEC_total.R
\name{NEC_total}
\alias{NEC_total}
\title{NEC algorithm}
\usage{
NEC_total(
  data,
  distance,
  centers_function,
  init_centers,
  seed = NULL,
  ITER,
  COTA,
  KK = 10,
  index = "DaviesBouldinIndex",
  k = NULL
)
}
\arguments{
\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}

\item{distance}{Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.}

\item{centers_function}{Function. This function designs how the centers of the groups will be calculated. It must have as input \code{data} and \code{grouping} and as output a matrix that has the centers. This matrix will have as many rows as centers. With \code{grouping} we mean a list. The list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.}

\item{init_centers}{Function. This function designs how we are going to calculate the initial centers. The input must be the \code{data}, \code{distance} and \code{k} and the output must be a matrix where each row has the center of one group.}

\item{seed}{Number. Number to fix a seed and be able to reproduce your results.}

\item{ITER}{Number. Maximum number of iterations.}

\item{COTA}{Number. The process is stopped when the distance between a center and the previous one is smaller than COTA.}

\item{KK}{Number. Calculates the algorithm  for the number of groups 2,3,...,KK. Default \code{KK=10}.}

\item{index}{Character. If \code{index="Silhouette"} the function returns the results obtained with the number of groups (between 2 and KK) that maximize the Silhouette index. If \code{index="DaviesBouldin"} the function returns the results obtained with the number of groups (between 2 and KK) that minimize the Davies Bouldin index. If \code{index="Dunn"} the function returns the results obtained with the number of groups (between 2 and KK) that maximize the Dunn index. Default: "DaviesBouldin".}

\item{k}{Number. If k is not NULL the function returns the results obtained with  k groups.}
}
\value{
Returns a list with:
  \itemize{
  \item Number_of_groups: Number of groups took into account to cluster.
  \item Output_of_grouping: list with the centers and the clusters.
 \item Quality: vector with the Silhouette index, Davies Bouldin Index, the Dunn index, the Within Cluster Sum (WCS) and the time (in seconds) that algorithm needs to be executed. The WCS is equal to the sum of the distance of each point to the center of its group.
   }
}
\description{
This function apply the NEC to different number of groups and calculates quality metrics as Silhouette.
}
\examples{

set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
         matrix(runif(20,20,30), nrow = 2, ncol = 10),
         matrix(runif(20,50,70), nrow = 2, ncol = 10))

RES=NEC_total(data,
             RelativeDistance,
             centers_function_RelativeDistance,
             init_centers_random,
             seed=10,
             ITER=10,
             0.01,
             KK=4,
             index="DaviesBould",
             k=NULL)


}
