
#' Initializing the centers
#'
#' This function initializes the centers of the groups randomly.
#'
#'
#' @param data Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.
#' @param distance Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.
#' @param k Number. Number of groups into which we are going to group the different points.
#' @param centers_function Function. This function designs how the centers of the groups will be calculated. It must have as input \code{data} and \code{grouping} and as output a matrix that has the centers. This matrix will have as many rows as centers. With \code{grouping} we mean a list. The list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
#'
#' @return Returns a matrix where each row is the center of a group.
#'
#'
#' @examples
#'
#'set.seed(451)
#'data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
#'           matrix(runif(20,20,30), nrow = 2, ncol = 10),
#'           matrix(runif(20,50,70), nrow = 2, ncol = 10))
#'k=3
#'seed=5
#'
#'centr=init_centers_random(data, EuclideanDistance,k,centers_function_mean)
#'
#'
#'
#' @export






init_centers_random<-function(data, distance,k,centers_function){
  centers=data[sample(1:nrow(data), k), ]
  return(centers)
}
