% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_CRP.R
\name{do.crp}
\alias{do.crp}
\title{Collaborative Representation-based Projection}
\usage{
do.crp(
  X,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  lambda = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{lambda}{regularization parameter for constructing \eqn{\ell_2} graph.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Collaborative Representation-based Projection (CRP) is an unsupervised linear
dimension reduction method. Its embedding is based on \eqn{\ell}_2 graph construction,
similar to that of SPP where sparsity constraint is imposed via \eqn{\ell_1} optimization problem.
Note that though it may be way faster, rank deficiency can pose a great deal of problems,
especially when the dataset is large.
}
\examples{
## use iris dataset
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
lab   = as.factor(iris[subid,5])

## test different regularization parameters
out1 <- do.crp(X,ndim=2,lambda=0.1)
out2 <- do.crp(X,ndim=2,lambda=1)
out3 <- do.crp(X,ndim=2,lambda=10)

# visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=lab, pch=19, main="CRP::lambda=0.1")
plot(out2$Y, col=lab, pch=19, main="CRP::lambda=1")
plot(out3$Y, col=lab, pch=19, main="CRP::lambda=10")
par(opar)

}
\references{
\insertRef{yang_collaborative_2015}{Rdimtools}
}
\seealso{
\code{\link{do.spp}}
}
\author{
Kisung You
}
\concept{linear_methods}
