

\name{image_TempDepthProfiles}
\alias{image_TempDepthProfiles}

\title{
plots interpolated daily temperature at depth profiles
}
\description{
plots interpolated daily temperature at depth profiles, thus faciliating the analysis of temporal changes of temperature profiles, for instance, in relation to animal behaviour (e.g. diving behaviour). See Bauer et al. (2015) for further examples.
}

\usage{
image_TempDepthProfiles(x, main=NULL, xlab='Date', ylab="Depth (m)", 
                        cb.xlab=expression(paste("Temperature (",degree,"C)")), 
                        cex.cb.xlab=1, cex.cb.ticks=1,
                        xlim, ylim, zlim, pal="jet", only.months, month.line=0, 
                        mars, axes=TRUE, do.colorbar=TRUE, ...)
}
 

\arguments{
\item{x}{
A list , generated by \link{interpolate_TempDepthProfiles} or \link{interpolate_PDTs}, containing interpolated temperature at depth profiles and their corresponding date and interpolated depth values as well as a summary table with the original depth values and their number per day:

  $ Temperature_matrix: num\cr
  $ Depth           : num\cr 
  $ Date            :Date\cr
  $ sm            :data.frame\cr

}
\item{main, xlab, ylab}{
the title, x- and y-axis labels to be plotted. 
}

\item{cb.xlab}{
character string indicating the x-axis label of the colorbar.
}

\item{cex.cb.xlab, cex.cb.ticks}{
  \emph{cex.cb.xlab}: font size of the x-axis label of the colorbar (by default 1).
  \emph{cex.cb.ticks}: font size of the x-axis tick labels of the colorbar (by default 1).
}

\item{xlim, ylim, zlim}{the x, y and z limits of the plot.
}

\item{pal}{
color map to be plotted (default is \code{'jet'}). See \link[oceanmap]{cmap} for available color maps.
}

\item{only.months, month.line}{
whether only mid-months shall be plotted as tick labels of the x-axis (by default FALSE for time ranges of less than 3 months (93 days)).
In case, that only.months is set \code{TRUE}, \code{month.line} defines the line where the month labels shall be plotted.
}

\item{mars}{
a numerical vector defining the plot margins \code{c(bottom, left, top, right)} (by default \code{c(5,4,4,9)}).
}

\item{axes, do.colorbar}{
whether the axes and colorbar should be plotted.
}

\item{\dots}{
additional arguments to be passed to \link[oceanmap]{set.colorbarp}
}

}

\references{
Bauer, R., F. Forget and JM. Fromentin (2015) Optimizing PAT data transmission: assessing the accuracy of temperature summary data to estimate environmental conditions. Fisheries Oceanography, 24(6): 533-539, 
\doi{10.1111/fog.12127}
}

\seealso{\link{read_PDT}, \link{bin_TempTS}, \link{get_thermalstrat}, \link{image_TempDepthProfiles}} 


\author{
Robert K. Bauer
}

\examples{
#### example 1) run on PDT file:
## step I) read sample PDT data file:
path <- system.file("example_files",package="RchivalTag")
PDT <- read_PDT("104659-PDTs.csv",folder=path)
head(PDT)
# 
# ## step II) interpolate average temperature fields (MeanPDT) from PDT file:
# m <- interpolate_PDTs(PDT)
# str(m)
# m$sm
# 
# ## step III) calculate thermal stratifcation indicators per day (and tag):
# get_thermalstrat(m, all_info = TRUE)
# get_thermalstrat(m, all_info = FALSE)
# 
# ## step IV) plot interpolated profiles:
# image_TempDepthProfiles(m$station.1)
# 
# 
# #### example 2) run on time series data:
# ## step I) read sample time series data file:
# DepthTempTS <- read.table(system.file("example_files/104659-Series.csv",
#                                       package="RchivalTag"),header = TRUE,sep=',')
# DepthTempTS$date <- as.Date(DepthTempTS$Day,"\%d-\%b-\%Y")
# head(DepthTempTS)
# 
# 
# ## step Ib) bin temperature data on 10m depth bins 
# ##          to increase later estimate accuracy (see Bauer et al. 2015):
# # DepthTempTS_binned <- bin_TempTS(DepthTempTS,res=10)
# 
# ## step II) interpolate average temperature fields (MeanTemp) from binned data:
# m <- interpolate_TempDepthProfiles(DepthTempTS)
# # m <- interpolate_PDTs(DepthTempTS_binned)
# str(m)
# m$sm
# 
# ## step III) calculate thermal stratifcation indicators per day (and tag):
# get_thermalstrat(m, all_info = TRUE)
# get_thermalstrat(m, all_info = FALSE)
# 
# ## step IV) plot interpolated profiles:
# image_TempDepthProfiles(m$station.1)

}

