% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_flow_spaghetti.R
\name{rvn_flow_spaghetti}
\alias{rvn_flow_spaghetti}
\title{Flow Spaghetti Plot}
\usage{
rvn_flow_spaghetti(flow)
}
\arguments{
\item{flow}{time series object of simulated flows}
}
\value{
\item{TRUE}{return \code{TRUE} if the function is executed properly}
}
\description{
rvn_flow_spaghetti creates a spaghetti plot of the flow series provided.
}
\details{
Creates a spaghetti plot of the annual flow series in each
year of data provided. The flows are plotted for each water year of data
available, set as October 1st.

Note that the plotting to the day of year is approximate in order to
simplify the plotting of leap years and non-leap years. The years are
plotted including day 366 and starting on day 274, regardless of whether it
is a leap year or not. This is likely without consequence in seeing the
trends between water years, however the user is warned of this deficiency.

The flow series provided should be of time series (xts) format.

Note that a plot title is purposely omitted in order to allow the automatic
generation of plot titles.
}
\examples{

# load sample hydrograph data, two years worth of sim/obs
data(rvn_hydrograph_data)

# create spaghetti plot of simulated flows
rvn_flow_spaghetti(rvn_hydrograph_data$hyd$Sub36)

# create spaghetti plot of observed flows
rvn_flow_spaghetti(rvn_hydrograph_data$hyd$Sub36_obs)

}
\seealso{
\code{\link{rvn_flow_scatterplot}} to create a scatterplot of flow
values
}
