% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{rand_walk_helper}
\alias{rand_walk_helper}
\title{Random Walk Helper}
\usage{
rand_walk_helper(.data, .value)
}
\arguments{
\item{.data}{The data frame to mutate.}

\item{.value}{The .initial_value to use. This is passed from the random walk
function being called by the end user.}
}
\value{
A modified data frame/tibble with the following columns added:
\itemize{
\item \code{cum_sum}: Cumulative sum of \code{y}.
\item \code{cum_prod}: Cumulative product of \code{y}.
\item \code{cum_min}: Cumulative minimum of \code{y}.
\item \code{cum_max}: Cumulative maximum of \code{y}.
\item \code{cum_mean}: Cumulative mean of \code{y}.
}
}
\description{
A function to help build random walks by mutating a data frame.
}
\details{
A function to help build random walks by mutating a data frame. This mutation
adds the following columns to the data frame: \code{cum_sum}, \code{cum_prod}, \code{cum_min},
\code{cum_max}, and \code{cum_mean}. The function is used internally by certain functions
that generate random walks.
}
\examples{
df <- data.frame(
  walk_number = factor(rep(1L:25L, each = 30L)),
  x = rep(1L:30L, 25L),
  y = rnorm(750L, 0L, 1L)
  )

rand_walk_helper(df, 100)

}
\seealso{
Other Utility Functions: 
\code{\link{confidence_interval}()},
\code{\link{convert_snake_to_title_case}()},
\code{\link{generate_caption}()},
\code{\link{get_attributes}()},
\code{\link{rand_walk_column_names}()},
\code{\link{running_quantile}()},
\code{\link{std_cum_max_augment}()},
\code{\link{std_cum_mean_augment}()},
\code{\link{std_cum_min_augment}()},
\code{\link{std_cum_prod_augment}()},
\code{\link{std_cum_sum_augment}()},
\code{\link{subset_walks}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility Functions}
