% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zilnorm.R
\name{zilnorm}
\alias{zilnorm}
\alias{dzilnorm}
\alias{pzilnorm}
\alias{rzilnorm}
\alias{plnorm}
\title{Zero-inflated log normal distribution}
\usage{
dzilnorm(x, meanlog = 0, sdlog = 1, zeroprob = 0, log = FALSE)

pzilnorm(q, meanlog = 0, sdlog = 1, zeroprob = 0,
         lower.tail = TRUE, log.p = FALSE)

rzilnorm(n, meanlog = 0, sdlog = 1, zeroprob = 0)

plnorm(q, meanlog = 0, sdlog = 1, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{meanlog, sdlog}{mean and standard deviation of the distribution on the log scale with default values of 0 and 1 respectively.}

\item{zeroprob}{zero-inflation probability between 0 and 1.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return}
}
\value{
\code{dzilnorm} gives the density, \code{pzilnorm} gives the distribution function, and \code{rzilnorm} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the zero-inflated log normal distribution.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
x <- rzilnorm(1, 1, 1, 0.5)
d <- dzilnorm(x, 1, 1, 0.5)
p <- pzilnorm(x, 1, 1, 0.5)
}
