% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_estimate.R
\name{rsdc_estimate}
\alias{rsdc_estimate}
\title{Estimate Regime-Switching or Constant Correlation Model (Wrapper)}
\usage{
rsdc_estimate(
  method = c("tvtp", "noX", "const"),
  residuals,
  N = 2,
  X = NULL,
  out_of_sample = FALSE,
  control = list()
)
}
\arguments{
\item{method}{Character. One of \code{"tvtp"}, \code{"noX"}, \code{"const"}.}

\item{residuals}{Numeric matrix \eqn{T \times K}. Typically standardized residuals/returns.}

\item{N}{Integer. Number of regimes. Ignored when \code{method = "const"}.}

\item{X}{Numeric matrix \eqn{T \times p} of exogenous covariates (required for \code{"tvtp"}).}

\item{out_of_sample}{Logical. If \code{TRUE}, a fixed 70/30 split is applied prior to estimation.}

\item{control}{Optional list. Currently forwards \code{do_trace = FALSE} and \code{seed = 123} to the backends.}
}
\value{
\describe{
\item{\code{transition_matrix}}{Estimated transition matrix (\eqn{1 \times 1} for \code{"const"}).}
\item{\code{correlations}}{Regime lower-triangular correlations.}
\item{\code{covariances}}{Array of full correlation matrices.}
\item{\code{log_likelihood}}{Maximized log-likelihood.}
\item{\code{beta}}{TVTP coefficients (only for \code{"tvtp"}).}
}
}
\description{
Unified front-end that dispatches to one of three estimators:
\itemize{
\item \code{f_optim()} — TVTP specification (\code{method = "tvtp"}).
\item \code{f_optim_noX()} — fixed transition matrix (\code{method = "noX"}).
\item \code{f_optim_const()} — constant correlation, single regime (\code{method = "const"}).
}
}
\details{
\itemize{
\item \strong{Method selection:} \code{match.arg()} validates \code{method}.
\item \strong{Inputs:} \code{"tvtp"} requires non-NULL \code{X}; \code{N} is ignored for \code{"const"}.
\item \strong{Split:} If \code{out_of_sample = TRUE}, the first 70\\% is used for fitting.
}
}
\examples{
\donttest{
y <- scale(matrix(rnorm(100 * 3), 100, 3))
rsdc_estimate("const", residuals = y)
rsdc_estimate("noX", residuals = y, N = 2)
X <- cbind(1, scale(seq_len(nrow(y))))
rsdc_estimate("tvtp", residuals = y, N = 2, X = X)
}

}
\references{
\insertRef{DEoptim-JSS}{RSDC} \cr

\insertRef{hamilton1989}{RSDC} \cr

\insertRef{pelletier2006regime}{RSDC}
}
\seealso{
\code{\link{rsdc_hamilton}} and \code{\link{rsdc_likelihood}}.
}
