% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lollipoPlot.R
\name{lollipoPlot}
\alias{lollipoPlot}
\title{Lollipop charts}
\usage{
lollipoPlot(values, type = "v", pt.lwd = NULL, pt.col = NULL, ...)
}
\arguments{
\item{values}{either a vector, matrix, or data.frame of data. If matrix or
data.frame including two columns, a dumbbell dots chart is plotted.}

\item{type}{plot direction, either vertical ("v", the default) or horizontal
("h").}

\item{pt.lwd}{points lwd}

\item{pt.col}{points color}

\item{...}{other arguments passed to the functions \code{plot},
\code{points}, and \code{segments}.}
}
\description{
The function generates lollipop or dumbbell dots charts.
}
\details{
If a dumbbell dots chart is plotted, different parameters (i.e.
  col/cex/pch/bg/lwd) for starting and ending points can be supplied. See
  example for further details.
}
\examples{
require(emmeans)

lollipoPlot(values=feedlot[,4],pt.col="green",pt.lwd=2,lwd=0.8,col="gray20",
            ylab="swt",xlab="samples")

line.col<-sample(colors()[-1],length(levels(feedlot[,1])))
line.col<-rep(line.col,times=table(feedlot[,1]))

lollipoPlot(values=feedlot[order(feedlot[,1]),3],ylab="ewt",xlab="samples",
            bg=as.numeric(as.factor(feedlot[order(feedlot[,1]),2])),
            cex=1.2,pch=21,col=line.col)



lollipoPlot(values=feedlot[order(feedlot[,1]),3:4],type="h",ylab="ewt",xlab="samples",
            pt.col=c("blue","cyan"),cex=1.2,pch=c(3,4),col=line.col)

lollipoPlot(values=feedlot[order(feedlot[,1]),3:4],type="h",ylab="ewt",xlab="samples",
            bg=cbind(line.col,line.col),cex=c(1.2,1),pch=c(21,22))
}
\author{
Silvia Castiglione, Carmela Serio, Pasquale Raia
}
