% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{results_volcano}
\alias{results_volcano}
\title{results_volcano}
\usage{
results_volcano(
  data,
  mode,
  p.threshold = 0.05,
  FCh.threshold = 2,
  sel.Gene = "all",
  point.size = 4,
  point.shape = 19,
  alpha = 0.7,
  colors = c("#66c2a5", "#fc8d62"),
  add.thr.lines = TRUE,
  linewidth = 0.25,
  linetype = "dashed",
  x.axis.title = "log2(fold change)",
  y.axis.title = "-log10(p value)",
  axis.title.size = 11,
  axis.text.size = 10,
  legend.text.size = 11,
  legend.title = "Selected as significant?",
  legend.title.size = 11,
  legend.position = "top",
  plot.title = "",
  plot.title.size = 14,
  dpi = 600,
  width = 15,
  height = 15,
  save.to.tiff = FALSE,
  name.tiff = "results_volcano"
)
}
\arguments{
\item{data}{Object returned from RQ_dCt() or RQ_ddCt() functions.}

\item{mode}{Character: which p value should be used? One of the "t" (p values from Student's t test), "t.adj" (adjusted p values from Student's t test),
"mw" (p values from Mann-Whitney U test),"mw.adj" (adjusted p values from Mann-Whitney U test),
"depends" (if data in both compared groups were considered as derived from normal distribution
(p value from Shapiro_Wilk test > 0.05) - p values from Student's t test will be used for significance assignment,
otherwise p values from Mann-Whitney U test will be used), "depends.adj"
(if data in both compared groups were considered as derived from normal distribution
(p value from Shapiro_Wilk test > 0.05) - adjusted p values from Student's t test will be used for significance assignment,
otherwise adjusted p values from Mann-Whitney U test will be used), and "user" that can be used
the user intend to use another p values, e.g. obtained from other statistical test. In such situation, before run FCh_plot function, the user should prepare
data frame object named "user" that contains two columns, the first of them with Gene names and the second with p values.
The order of columns must be kept as described.}

\item{p.threshold}{Numeric: threshold of p values for statistical significance.}

\item{FCh.threshold}{Numeric: threshold of fold change values used for significance assignment of genes.
If is set to 2 (default), genes with 2-fold changed expression (increased or decreased) between groups will be assigned as significant.}

\item{sel.Gene}{Character vector with names of genes to include, or "all" (default) to use all names of genes.}

\item{point.size}{Numeric: size of points. Default to 4.}

\item{point.shape}{Integer: shape of points. Default to 19..}

\item{alpha}{Numeric: transparency of points, a value between 0 and 1. Default to 0.7.}

\item{colors}{Character vector length of two, containing colors for significant and no significant genes.}

\item{add.thr.lines}{Logical, if TRUE (default), threshold lines will be added to the plot.}

\item{linewidth}{Numeric: width of the added threshold lines. Default to 0.25.}

\item{linetype}{Character: type of the added threshold lines. One of the "solid", "dashed" (default), "dotted",
"dotdash", "longdash", "twodash", and "blank".}

\item{x.axis.title}{Character: title of x axis. Default to "Gene".}

\item{y.axis.title}{Character: title of y axis. Default to "value".}

\item{axis.title.size}{Integer: font size of axis titles. Default to 11.}

\item{axis.text.size}{Integer: font size of axis text. Default to 10.}

\item{legend.text.size}{Integer: font size of legend text. Default to 11.}

\item{legend.title}{Character: title of legend. Default to "Group".}

\item{legend.title.size}{Integer: font size of legend title. Default to 11.}

\item{legend.position}{Position of the legend, can be one of "top" (default), "right", "bottom", "left", or "none" (no legend).
See description for legend.position in ggplot2::theme() function.}

\item{plot.title}{Character: title of plot. Default to "".}

\item{plot.title.size}{Integer: font size of plot title. Default to 14.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{name.tiff}{Character: name of saved .tiff file, without ".tiff" name of extension. Default to "FCh_plot".}
}
\value{
List containing object with barplot and data frame with results. Created plot is also displayed on graphic device.
}
\description{
This function creates volcano plot that illustrate the arrangement of genes based on
fold change values and p values. Significant genes can be pointed out using
specified p value and fold change thresholds, and highlighted on the plot by color and (optionally) isolated by thresholds lines.
}
\examples{
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                       remove.Gene = c("FGF23","ANGPT2","IL1A","CSF2","IL6"),
                       remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "GAPDH")
data.dCtF <- filter_transformed_data(data.dCt, remove.Sample = c("Control11"))
results.dCt <- RQ_dCt(data.dCtF, "AAA", "Control")

RQ.volcano <- results_volcano(data = results.dCt,
                         mode = "depends",
                         p.threshold = 0.05,
                         FCh.threshold = 2)
head(RQ.volcano[[2]])
}
