% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_roc.R
\name{npauc_lower_bounds}
\alias{npauc_lower_bounds}
\alias{add_npauc_lower_bound}
\alias{add_npauc_normalized_lower_bound}
\title{Add NpAUC lower bound to a ROC plot}
\usage{
add_npauc_lower_bound(
  data,
  response = NULL,
  predictor = NULL,
  threshold,
  .condition = NULL,
  .label = NULL
)

add_npauc_normalized_lower_bound(
  data,
  response = NULL,
  predictor = NULL,
  threshold,
  .condition = NULL,
  .label = NULL
)
}
\arguments{
\item{data}{A data.frame or extension (e.g. a tibble) containing values for
predictors and response variables.}

\item{response}{A data variable which must be a factor, integer or character
vector representing the prediction outcome on each observation
(\emph{Gold Standard}).

If the variable presents more than two possible outcomes, classes or
categories:
\itemize{
\item The outcome of interest (the one to be predicted) will remain distinct.
\item All other categories will be combined into a single category.
}

New combined category represents the "absence" of the condition to predict.
See \code{.condition} for more information.}

\item{predictor}{A data variable which must be numeric, representing values
of a classifier or predictor for each observation.}

\item{threshold}{A number between 0 and 1, inclusive. This number represents
the lower value of TPR for the region where to calculate and plot
lower bound.

Because of definition of \code{\link[=np_auc]{np_auc()}}, region upper bound will be established
as 1.}

\item{.condition}{A value from response that represents class, category or
condition of interest which wants to be predicted.

If \code{NULL}, condition of interest will be selected automatically depending on
\code{response} type.

Once the class of interest is selected, rest of them will be collapsed in a
common category, representing the "absence" of the condition to be predicted.

See \code{vignette("selecting-condition")} for further information on how
automatic selection is performed and details on selecting the condition of
interest.}

\item{.label}{A string representing the name used in labels.

If \code{NULL}, variable name from \code{predictor} will be used as label.}
}
\value{
A ggplot layer instance object.
}
\description{
Calculate and plot lower bound defined by NpAUC specificity index.
\itemize{
\item \code{add_npauc_normalized_lower_bound()} allows to plot normalized
lower bound, which is used to formally calculate NpAUC.
\item \code{add_npauc_lower_bound()} is a lower level function
providing a way to plot lower bound previous to normalization.
}
}
\examples{
plot_roc_curve(iris, response = Species, predictor = Sepal.Width) +
  add_npauc_lower_bound(
    iris,
    response = Species,
    predictor = Sepal.Width,
    threshold = 0.9
  )
}
