% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyring.R
\name{REDCapExporter_keyring}
\alias{REDCapExporter_keyring}
\alias{REDCapExporter_keyring_check}
\alias{REDCapExporter_add_api_token}
\alias{REDCapExporter_get_api_token}
\title{Set up and use of a Keyring for REDCap API Tokens}
\usage{
REDCapExporter_keyring_check(keyring = "REDCapExporter", password = NULL)

REDCapExporter_add_api_token(
  project,
  keyring = "REDCapExporter",
  user = NULL,
  password = NULL,
  overwrite = FALSE
)

REDCapExporter_get_api_token(
  project,
  keyring = "REDCapExporter",
  user = NULL,
  password = NULL
)
}
\arguments{
\item{keyring}{a character vector identifying the name of the keyring,
defaults to \code{"REDCapExporter"}}

\item{password}{This is the password for the keyring.  The default is an
empty password.}

\item{project}{the name of the REDCap project the API token is identified by.}

\item{user}{user name to associate the token with.  Defaults to
\code{Sys.info()[["user"]]}.}

\item{overwrite}{logical, if \code{TRUE} overwrite the existing token.}
}
\value{
\code{REDCapExporter_keyring_check} returns \code{TRUE}, invisibly,
as does \code{REDCapExporter_add_api_token}.
\code{REDCapExporter_get_api_token} returns the token invisibly as not to
print the value to the console by default.  Still, be careful with your
token.
}
\description{
Tools for checking for, and setting up, a file based keyring for storing
REDCap API tokens.
}
\examples{
\dontrun{
# Check if a keyring exisits. If it does not, create one.
REDCapExporter_keyring_check()

# add token if it does not already exist.  If a token
# already exists, then you will be told so unless overwrite is set to TRUE
REDCapExporter_add_api_token("Project1")

# get a token and set as an envrionmental variable
Sys.setenv(REDCap_API_TOKEN = REDCapExporter_get_api_token("Project1"))
}

}
\seealso{
\code{vignette(topic = "api", package = "REDCapExporter")}
}
