% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDML.init.R
\docType{methods}
\name{new}
\alias{new}
\alias{RDML.new}
\title{Creates new instance of \code{RDML} class object}
\arguments{
\item{filename}{\code{string} -- path to file}

\item{show.progress}{\code{logical} -- show loading progress bar if
\code{TRUE}}

\item{conditions.sep}{separator for condition defined at sample name}

\item{format}{\code{string} -- input file format. Possible values
\code{auto}, \code{rdml}, \code{abi}, \code{excel}, \code{csv}. See
Details.}
}
\description{
This function has been designed to import data from RDML v1.1 and v1.2 format
files or from \code{xls} file generated by \emph{Applied Biosystems 7500}. To
import from \code{xls} this file have to contain \code{Sample Setup} and
\code{Multicomponent Data} sheets!
}
\details{
File format options: \describe{\item{auto}{Tries to detect format by
extension. \code{.xlsx} -- \code{excel}, \code{.xls} -- \code{abi},
\code{.csv} -- \code{csv}, other -- \code{rdml}}\item{abi}{Reads \code{.xls}
files generated by \emph{ABI 7500 v.2}. To create such files use File>Export;
check 'Sample Setup' and 'Multicomponent Data'; select 'One File'}
\item{excel}{\code{.xls} or \code{.xslx} file with sheets 'description',
'adp', 'mdp'. See example file \code{table.xlsx}}\item{csv}{\code{.csv} file
with first column 'cyc' or 'tmp' and fluorescence data in other columns}
\item{rdml}{\code{.rdml} or \code{.lc96p} files}}
}
\section{Warning}{
 Although the format RDML claimed as data exchange format,
  the specific implementation of the format at devices from real
  manufacturers differ significantly. Currently this function is checked
  against RDML data from devices: \emph{Bio-Rad CFX96}, \emph{Roche
  LightCycler 96} and \emph{Applied Biosystems StepOne}.
}

\examples{
\dontrun{
## Import from RDML file
PATH <- path.package("RDML")
filename <- paste(PATH, "/extdata/", "lc96_bACTXY.rdml", sep ="")
lc96 <- RDML$new(filename)

## Some kind of overview for lc96
lc96$AsTable(name.pattern = sample[[react$sample$id]]$description)
lc96$AsDendrogram()
}
}
\author{
Konstantin A. Blagodatskikh <k.blag@yandex.ru>, Stefan Roediger
  <stefan.roediger@b-tu.de>, Michal Burdukiewicz
  <michalburdukiewicz@gmail.com>
}
