% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDML.GetFData.R
\docType{methods}
\name{RDML.GetFData}
\alias{RDML.GetFData}
\title{Gets fluorescence data vectors from \code{RDML} object}
\arguments{
\item{request}{Output from AsTable method(\link{RDML.AsTable})}

\item{dp.type}{Type of fluorescence data (i.e. 'adp' for qPCR or 'mdp' for
melting)}

\item{long.table}{Output table is ready for ggplot (See \link{RDML.AsTable}
for example)}
}
\value{
\code{matrix} which contains selected fluorescence data and 
  additional information fromm request if \code{long.table = TRUE}.
}
\description{
Gets fluorescence data vectors from \code{RDML} object for specified method
of experiment.
}
\examples{
## internal dataset BioRad_qPCR_melt.rdml (in 'data' directory)
## generated by Bio-Rad CFX96. Contains qPCR and melting data.
## Import without splitting by targets/types and with
## custom name pattern.
PATH <- path.package("RDML")
filename <- paste(PATH, "/extdata/", "BioRad_qPCR_melt.rdml", sep ="")
cfx96 <- RDML$new(filename)
## Select melting fluorescence data with sample.type 'unkn'.
library(dplyr)
tab <- cfx96$AsTable()
fdata <- cfx96$GetFData(filter(tab, sample.type == "unkn"),
                        dp.type = "adp")
## Show names for obtained fdata
colnames(fdata)
}
\author{
Konstantin A. Blagodatskikh <k.blag@yandex.ru>, Stefan Roediger 
  <stefan.roediger@b-tu.de>, Michal Burdukiewicz 
  <michalburdukiewicz@gmail.com>
}
\keyword{manip}
