% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_future_saving_rates.R
\name{plot_future_saving_rates}
\alias{plot_future_saving_rates}
\title{Plotting future saving rates}
\usage{
plot_future_saving_rates(
  scenario,
  aggregation_function = stats::median,
  y_limits = c(NA, NA)
)
}
\arguments{
\item{scenario}{A \code{tibble} with nested columns -
the result of \code{\link[=simulate_scenario]{simulate_scenario()}}. Data for a single scenario.}

\item{aggregation_function}{A function used to aggregate the saving rates
for multiple Monte Carlo samples. Default is \code{median}.
If \code{NULL}, no aggregation is performed.}

\item{y_limits}{A numeric vector of two values. Y-axis limits.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
This function plots the future saving rates from a scenario object.
}
\examples{
older_member <- HouseholdMember$new(
  name       = "older",  
  birth_date = "2000-02-15",
  mode       = 80,
  dispersion = 10
)  
household <- Household$new()
household$add_member(older_member)  

household$expected_income <- list(
  "income" = c(
    "members$older$age <= 65 ~ 10000 * 12"
  )
)
household$expected_spending <- list(
  "spending" = c(
    "TRUE ~ 5000 * 12"
  )
)

portfolio <- create_portfolio_template() 
portfolio$accounts$taxable <- c(10000, 30000)
portfolio$weights$human_capital <- c(0.2, 0.8)
portfolio$weights$liabilities <- c(0.1, 0.9)
portfolio <- 
  portfolio |> 
  calc_effective_tax_rate(
    tax_rate_ltcg            = 0.20, 
    tax_rate_ordinary_income = 0.40
  )

scenario <- 
  simulate_scenario(
   household    = household,
   portfolio    = portfolio,
   current_date = "2020-07-15"
  )

plot_future_saving_rates(scenario)
}
