% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gompertz.R
\name{calc_gompertz_survival_probability}
\alias{calc_gompertz_survival_probability}
\title{Calculating Gompertz survival probability}
\usage{
calc_gompertz_survival_probability(
  current_age,
  target_age,
  mode,
  dispersion,
  max_age = NULL
)
}
\arguments{
\item{current_age}{Current age}

\item{target_age}{Target age}

\item{mode}{Mode of the Gompertz distribution}

\item{dispersion}{Dispersion of the Gompertz distribution}

\item{max_age}{Maximum age. Defaults to \code{NULL}.}
}
\value{
A numeric. The probability of survival from 'current_age'
to 'target_age' based on the Gompertz distribution
with the given parameters.
}
\description{
Calculating Gompertz survival probability
}
\examples{
calc_gompertz_survival_probability(
  current_age = 65, 
  target_age  = 85, 
  mode        = 80, 
  dispersion  = 10
)
}
