% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setOption.R
\name{setOption}
\alias{setOption}
\title{Set Global Option from Named List Element}
\usage{
setOption(listElement)
}
\arguments{
\item{listElement}{An element from a named list, specified as `myList$element`.}
}
\value{
The function does not return anything but sets an option that can be retrieved
using `getOption(list_name)`.
}
\description{
This function takes an element from a named list as an argument,
and sets a global option based on the list's name.

Where :	optionName$element == "value",
calling	setOption(optionName$element)
triggers options(optionName = "value")
}
\details{
The function automatically extracts the list name from the argument.
The option is then dynamically set using `options(list_name = element)`.
}
\examples{
# Create a temporary list for demonstration
modelOption <- list(model1 = "model_1", model2 = "model_2", model3 = "model_3")

# Set the option
setOption(modelOption$model1)

# Retrieve the option
getOption("modelOption")  # Returns "model_1"

# Clean up
options(modelOption = NULL)

}
