% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_plots.R
\name{plot.gcFitLinear}
\alias{plot.gcFitLinear}
\title{Generic plot function for \code{gcFittedLinear} objects. Plot the results of a linear regression on ln-transformed data}
\usage{
\method{plot}{gcFitLinear}(
  x,
  log = "y",
  which = c("fit", "diagnostics", "fit_diagnostics"),
  pch = 21,
  cex.point = 1,
  cex.lab = 1.5,
  cex.axis = 1.3,
  lwd = 2,
  color = "firebrick3",
  y.lim = NULL,
  x.lim = NULL,
  plot = TRUE,
  export = FALSE,
  height = ifelse(which == "fit", 7, 5),
  width = ifelse(which == "fit", 9, 9),
  out.dir = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{gcFittedLinear} object created with \code{\link{growth.gcFitLinear}} or stored within a \code{grofit} or \code{gcFit} object created with \code{\link{growth.workflow}} or \code{\link{growth.gcFit}}, respectively.}

\item{log}{("x" or "y") Display the x- or y-axis on a logarithmic scale.}

\item{which}{("fit" or "diagnostics") Display either the results of the linear fit on the raw data or statistical evaluation of the linear regression.}

\item{pch}{(Numeric) Shape of the raw data symbols.}

\item{cex.point}{(Numeric) Size of the raw data points.}

\item{cex.lab}{(Numeric) Font size of axis titles.}

\item{cex.axis}{(Numeric) Font size of axis annotations.}

\item{lwd}{(Numeric) Line width.}

\item{color}{(Character string) Enter color either by name (e.g., red, blue, coral3) or via their hexadecimal code (e.g., #AE4371, #CCFF00FF, #0066FFFF). A full list of colors available by name can be found at http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}

\item{y.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on y-axis as a vector in the form \code{c(l, u)}.}

\item{x.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on the x-axis as a vector in the form \code{c(l, u)}.}

\item{plot}{(Logical) Show the generated plot in the \code{Plots} pane (\code{TRUE}) or not (\code{FALSE}).}

\item{export}{(Logical) Export the generated plot as PDF and PNG files (\code{TRUE}) or not (\code{FALSE}).}

\item{height}{(Numeric) Height of the exported image in inches.}

\item{width}{(Numeric) Width of the exported image in inches.}

\item{out.dir}{(Character) Name or path to a folder in which the exported files are stored. If \code{NULL}, a "Plots" folder is created in the current working directory to store the files in.}

\item{...}{Further arguments to refine the generated base R plot.}
}
\value{
A plot with the linear fit.
}
\description{
\code{plot.gcFitLinear} shows the results of a linear regression on log-transformed data and visualizes raw data, data points included in the fit, the tangent obtained by linear regression, and the lag time.
}
\examples{
# Create random growth dataset
rnd.dataset <- rdm.data(d = 35, mu = 0.8, A = 5, label = "Test1")

# Extract time and growth data for single sample
time <- rnd.dataset$time[1,]
data <- rnd.dataset$data[1,-(1:3)] # Remove identifier columns

# Perform linear fit
TestFit <- growth.gcFitLinear(time, data, gcID = "TestFit",
                 control = growth.control(fit.opt = "l"))

plot(TestFit)

}
