% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{login_bms}
\alias{login_bms}
\title{Login to the Server}
\usage{
login_bms(username = NULL, password = NULL, encoding = "json")
}
\arguments{
\item{username}{The username (optional, default is NULL). If not provided, the pop-up window is triggered.}

\item{password}{The password (optional, default is NULL). If not provided, the pop-up window is triggered.}

\item{encoding}{Specifies how the request body should be encoded: \code{form} (application/x-www-form-urlencoded), 
\code{multipart} (multipart/form-data), or \code{json} (application/json). Default is "json".}
}
\value{
No return value. The access token is stored internally for future use.
}
\description{
Connects to the BMS or related server using a username and password. If these are not provided,
a pop-up window will prompt the user to enter their credentials. The function handles authentication 
and stores the resulting access token internally for subsequent requests.
}
\examples{
if(interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench", engine = "bms")
  
  # Login using your BMS account (interactive mode)
  login_bms()
  
  # You can pass BMS username and password as parameters (batch mode)
  # login_bms("username", "password")
}

}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
