% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gigwa.R
\name{gigwa_list_runs}
\alias{gigwa_list_runs}
\title{Get the List of the Run Names Available in the Selected GIGWA Project}
\usage{
gigwa_list_runs()
}
\value{
A list of run names associated with the selected project.
}
\description{
Retrieve the list of available runs in the currently active GIGWA project, set using
\code{gigwa_set_project()}. If no project is selected, an error will be raised.
}
\examples{
if (interactive()) {
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                  time_out = 300, engine = "gigwa", no_auth = TRUE)
  gigwa_set_db("Sorghum-JGI_v1")
  gigwa_set_project("Nelson_et_al_2011")
  gigwa_list_runs()
}
}
\seealso{
\code{\link{set_qbms_config}}, \code{\link{gigwa_set_project}}
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
