% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ci.R
\name{summary.ci}
\alias{summary.ci}
\title{Summarize confidence intervals}
\usage{
\method{summary}{ci}(object, format = "[u;l]", se = FALSE, print = TRUE, ...)
}
\arguments{
\item{object}{Object of class ci containing point estimates and the
corresponding confidence intervals}

\item{format}{A string which indicates the format used for
confidence intervals.  The string is passed to
\link{formatCI} with two arguments: the lower and the upper
limit. For example \code{'(l;u)'} yields confidence intervals with
round parenthesis in which the upper and the lower limits are
separated by semicolon.}

\item{se}{If \code{TRUE} add standard error.}

\item{print}{Logical: if \code{FALSE} do not actually print
confidence intervals but just return them invisibly.}

\item{...}{used to control formatting of numbers}
}
\value{
Formatted confidence intervals
}
\description{
Summarize confidence intervals
}
\details{
This format of the confidence intervals is user-manipulable.
}
\examples{
library(lava)
m <- lvm(Y~X)
m <- categorical(m,Y~X,K=4)
set.seed(4)
d <- sim(m,24)
ci.mean(Y~X,data=d)
x <- summary(ci.mean(Y~X,data=d),digits=2)
x
x <- summary(ci.mean(Y~X,data=d),format="(u,l)",digits=2)
x <- summary(ci.mean(Y~X,data=d),format="(u,l)",digits=1,se=TRUE)
x <- summary(ci.mean(Y~X,data=d),format="(u,l)",digits=1,handler="format")
x <- summary(ci.mean(Y~X,data=d),format="(u,l)",digits=1,handler="prettyNum")
}
\seealso{
ci plot.ci format.ci
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
