% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.project.R
\name{create.project}
\alias{create.project}
\title{Create a new project.}
\usage{
create.project(
  project.name = "new-project",
  template = "full",
  dump = FALSE,
  merge.strategy = c("require.empty", "allow.non.conflict"),
  rstudio.project = FALSE
)
}
\arguments{
\item{project.name}{A character vector containing the name for this new
project. Must be a valid directory name for your file system.}

\item{template}{A character vector containing the name of the template to
use for this project. By default a \code{full} and \code{minimal} template
are provided, but custom templates can be created using
\code{create.template}.}

\item{dump}{A boolean value indicating whether the entire functionality
of ProjectTemplate should be written out to flat files in the current
project.}

\item{merge.strategy}{What should happen if the target directory exists and
is not empty?
If \code{"force.empty"}, the target directory must be empty;
if \code{"allow.non.conflict"}, the method succeeds if no files or
directories with the same name exist in the target directory.}

\item{rstudio.project}{A boolean value indicating whether the project should
also be an 'RStudio Project'. Defaults to \code{FALSE}. If \code{TRUE},
then a `projectname.Rproj` with usable defaults is added to the ProjectTemplate
directory.}
}
\value{
No value is returned; this function is called for its side effects.
}
\description{
This function will create all of the scaffolding for a new project.
It will set up all of the relevant directories and their initial
contents. For those who only want the minimal functionality, the
\code{template} argument can be set to \code{minimal} to create a subset of
ProjectTemplate's default directories. For those who want to dump
all of ProjectTemplate's functionality into a directory for extensive
customization, the \code{dump} argument can be set to \code{TRUE}.
}
\details{
If the target directory does not exist, it is created.  Otherwise,
  it can only contain files and directories allowed by the merge strategy.
}
\examples{
library('ProjectTemplate')

\dontrun{create.project('MyProject')}
}
\seealso{
\code{\link{load.project}}, \code{\link{get.project}},
  \code{\link{cache.project}}, \code{\link{show.project}}
}
